# 第四章 开源行业发展现状

作为行业发展的重要基石，开源已经成为促进全球各行业转型升级、推动数字经济快速发展的中坚力量，行业业已形成拥抱开源、使用开源的共识。未来，开源将在传统企业展现更多的力量，而行业积极拥抱开源、引入开源软件的背后，是其业务发展导致的企业对持续变化的业务需求响应能力、软件性能及成本与效率方面的考虑。出于传统行业的增长需求、市场环境的变化、客户需求的多样性等原因，传统企业自身的研发能力不足以支撑企业敏捷响应、快速迭代、开发，制约了企业的快速发展。但企业根据需求自研系统或引入外部商业软件都会带来高昂的采购成本、维护成本和人力投入。

在此背景下，开源由于其开放式协作的特点，使得开发流程更为敏捷，业务需求和变化能快速得到响应，而且开源社区为企业与外部精英提供合作平台，可以解决短期内传统行业研发实力不足的问题。引入开源软件意味着企业可以基于原有开源代码自行开发或只需采购增量服务，节约时间、人力、经济成本。传统行业引入开源软件提升了企业业务竞争力，驱动了企业数字化转型，帮助企业系统实现了安全性和可靠性提升。从全局角度而言，传统行业拥抱开源为其带来了新的增长机遇。

据信通院在《全球开源生态研究报告（2022）》中指出，开源开放是数字化催生的新“创新范式”，开源通过数字技术扩散互联促进数字技术创新，进而加速数字化转型。一方面，企业通过开源开放充分集结全社会智力资源，与外部创新主体协同创新，搭建企业技术创新入口和交互平台，获得“数字化生存”的动态技术创新能力。另一方面，开源战略通过核心开源产品快速建立一个以开源技术为平台、参与者相互赋能的行业生态圈。数字企业通过开源产品，与上下游企业形成共享代码、协同开发、成本分摊的战略联盟，能够充分发挥各个企业的竞争优势与核心能力，增强企业之间的资源互补，有效地扩大行业业务范围，加速行业数字化转型。

## 4.1 开源在金融行业的应用

> 作者：
> 
> 罗文江，招商银行资深云计算架构师、开放原子开源基金会TOC成员
> 
> 刘建珍，中国农业银行研发中心高级专员

### 4.1.1 2022-2023年金融行业开源发展现状

#### 开源技术已渗透金融全场景，机遇与挑战并存

金融行业在强化技术掌控和提质增效的双重压力下，越来越多地选择开源技术产品作为其基础技术架构组成部分。金融行业通过开源技术支持企业核心技术框架，既能保证接轨国际主流技术，又能确保以深度参与的方式完成金融信息建设，实现从“可用”到“好用”的转变。根据北京金融科技产业联盟调研报告显示，90%的金融机构已官方应用和试用开源软件。开源技术已成为金融服务的重要技术支撑。据金融行业开源技术应用社区的“2022金融行业开源技术应用调查”显示，47.06%的金融机构开源架构资产库系统使用开源组件和软件的清单列表数量在1000至10000之间，35.29%的金融机构开源架构资产库系统使用开源组件和软件的清单列表数量小于1000，另有11.76%的金融机构使用开源组件和软件的清单列表数量在1万至10万之间，5.88%的公司开源架构资产库系统使用开源组件和软件的清单列表数量在10万以上。

以农业银行为例，农业银行已规范使用超过2万多个，7000多种开源软件，涉及30多种开源许可证，有力支撑了金融科技创新，例如，基于Spring Boot框架建设了综合应用平台，提供完善的基础架构降低开发技术难度，让研发人员能够专注业务，快速开发出复杂的业务功能；基于NGINX建设了综合网管平台，为应用系统提供多样的软负载均衡能力，支持TCP/HTTP/HTTPS等多种协议。基于Hudi、Alluxion、Flink、Atlas等6项开源技术，创新融合存算分离、流批一体、湖仓一体多元技术，探索构建了存储云+计算云+工具云的大数据新型技术架构，验证了大数据新型技术栈在金融场景的可行性，为金融同业提供了可借鉴的示范案例。

开源技术为金融机构带来科技创新、业务赋能等积极成效的同时，也带来了包括技术风险、法律风险、供应链风险在内的诸多挑战。日益增多的开源安全漏洞、恶意软件植入、开源许可证冲突、关键组件瓶颈等，已成为金融企业广泛运用开源技术亟待解决的问题。

#### 金融行业积极布局开源发展，陆续出台多项政策规范，提供金融业开源治理和生态建设基本遵循

因开源技术的广泛使用，金融行业日益重视开源治理和开源生态建设，2021年10月，人民银行办公厅、中央网信办秘书局、工业和信息化部办公厅、银保监会办公厅、证监会办公厅联合发布《关于规范金融业开源技术应用与发展的意见》（以下简称《意见》）。整体从金融机构使用开源、自发开源、开源生态构建、构建标准和法律体系等4个方面提出了指导意见，并鼓励“金融机构将开源技术应用作为提高核心技术自主可控能力的重要手段”、鼓励“金融机构积极参与开源生态建设”和“开展开源项目合作，实现优势互补、互利共赢、共同发展”。同年人行发布的《金融科技发展规划（2022-2025）》提出了要在开源生态方面“依法合规参与数字技术开源社区等创新联合体”。行业相关政策陆续出台，规范和鼓励了金融机构安全合规应用开源技术，促进了金融行业开源生态培育和发展，推动了金融机构的数字化转型。

2022年金融行业开源相关标准规范陆续出台，护航金融业参与开源生态行稳致远。在行业标准方面，《金融业开源软件应用管理指南》《金融信息系统开源软件应用评估规范》《金融业开源技术术语》为进一步规范金融 机构开源软件的资产管理提供了宝贵的经验。《金融行业开源软件评测规范》、《金融行业开源软件服务商评测规范》为银行机构评估和选择合适的开源软件及服务商提供参考依据，保障银行业开源软件的应用安全，促使开源软件服务商提升企业竞争。《金融技术产品开源项目管理指南》保障金融技术产品开源管理流程的规范性和可行性，促进金融机构合法合规、拥抱开源。

#### 金融机构逐渐强化开源治理，尝试探索对外开源

在内部开源治理方面，超70%的金融机构具有开源相关治理流程，其中41.18%的企业有多个开源相关治理流程，29.41%的企业有1个开源治理流程。另有29.41%的企业尚无开源治理相关流程。70.59%的公司无单独开源管理团队，17.65%的公司拥有单独开源管理团队，其中1人专职，5-10人兼职；11.76%的公司具备2-3人专职，10-20人兼职的单独开源管理团队。多家大型商业银行已制定企业级开源治理流程，具备明确开源管理人员责任划分，保障开源技术的安全可控应用。例如，中国农业银行结合商业银行特点和自身实践涉及了一套融合传统和开源理念的软件管理体系和框架TOSIM（Tranditional&Open-source Software Integrated Management），规范企业内部开源管理；交行也根据自身企业技术架构发展，制定了开源软件管理办法、开源依赖库管理细则等，形成开源软件管理模型；浦发银行成立了开源治理配套组织架构，建设了开源治理平台实现开源软件全流程、一体化、自动化管理；中国银行打造了包括开源技术架构师、开源安全专家、开源软件开发专家在内的三支专家队伍，确保高效协同；中信银行成立了专业开源治理团队，启动开源治理平台建设，实现开源资产管理线上化。

在行业开源生态建设方面，金融机构逐步凝聚开源发展共识，共建行业开源平台社区生态，增强行业合作，解决共性问题，开始培育、支持开源项目孵化与推广。北京科技产业联盟组织、中国银联承建了金融开源平台（OFTP），赋能金融领域开源项目孵化，为用户提供高质量的软件源码托管平台，当前已接入70多家金融机构，承接了如金融业生僻字处里项目、金融业开源项目生态检测平台等多个行业开源项目。 此外联盟还发起金融业开源技术信息服务平台FOST风险信息共享计划，依托平台风险同胞服务模块，为金融机构共享已知开源漏洞及风险信息，建立了风险漏洞和安全实践的发现和共享机制，提高金融业开源技术风险防范和处置能力。招商银行和阿里、百度、华为、浪潮、腾讯、360等10家创始会员共同筹建成立开放原子开源基金会，基金会为国内首个开源基金会，当前在操作系统、数据库、云计算、安全、大数据、区块链等领域已有30多个开源孵化项目。

在对外开源方面，部分金融机构逐渐从原来的开源技术的使用方，开始尝试输出贡献。以微众银行、网商银行、蚂蚁金服为代表的互联网银行主动拥抱开源技术，积极也参与开源社区，同时，反哺社区，通过将内部孵化的产品进行开源，捐赠给开源社区，2022年蚂蚁开源可信隐私计算开源框架“隐语”、高性能图数据库TuGraph单机版、SOFAStack 云原生项目。微众银行在人工智能、区块链、云计算、大数据等多个领域开源33个项目，其中：FATE开源社区在2022年荣获 中国信通院“2022 OSCAR 尖峰开源社区及开源项目”，与开放群岛开源社区、百度、腾讯云和京东科技共同发起了“隐私计算开源协同计划”；EventMesh项目在2022年被CNCF Landscape收录，2023年初成功从Apache基金会孵化器毕业成为顶级项目；大数据计算中间件项目Linkis 于2022年成功成为Apache基金会的顶级项目。工商银行、 中国银行、招商银行、浦发银行、浙商银行等参与区块链跨链陆羽开源项目；工商银行等与科技企业合作开展MySQL数据库金融分支版本项目; 招商银行参与共建KubeVela项目，对外开源EasyBaaS项目和ChainHub项目；光大银行与趣链科技合作开展区块链BaaS平台跨链子平台项目。

在内部开源方面，64.71%的金融机构实施了企业或集团内部开源，35.29%的企业还未实施。缺乏专门的开源管理团队和企业级的开源文化认同以及安全、商务、法律因素是内部开源的最大阻力。

### 4.1.2 金融行业开源发展的问题与挑战

金融行业开源要得到长足发展，必然面临开源领域普遍会遇到的开源许可证合规风险、供应链风险、代码安全风险、自主创新风险和运维服务支持风险，各家金融机构也面临自身IT转型过程中的开源发展问题与挑战。

#### 开源许可证合规风险高

许可证合规性是金融机构引入、使用、治理开源软件面临的首要问题。同时，也需要保护金融机构自身的知识产权免遭传染性许可证侵害。目前，国际公认的开源许可证91种，主流使用的许可证也有9种（截至2020年12月19日，OSI），其中大多采用英文编写，只有木兰许可证采用中文编写。金融机构需要有具备熟悉许可证特性与要求的法律法规团队支持，并建设在开源软件全生命周期内动态管理、定期扫描，发挥监控、评估等能力。

#### 缺少运维支持服务风险

开源软件相较闭源商业软件缺少完善的运维保障支持。对开源软件应用中出现的安全漏洞、隐私风险，金融机构需要自行分析解决。此外，金融机构对开源软件二次开发的代码，因其针对金融特定场景不具有通用性，在开源软件进行大版本升级后，金融机构仍需要重复开发、测试、上线。

#### 开源商业模式运营公司的不可持续服务风险

开源软件独特的商业运营模式，使成功的开源软件几乎都由成熟商业组织推动，在无法为其商业模式带来流量、关注度等回报，或开源软件的存在对其盈利造成影响时，开源软件将面临人员投入、资金支持、代码贡献调整的风险。

#### 缺少统一安全管理风险

金融行业普遍应用了成千上万的开源软件，开源软件之间的依赖关系趋于复杂，管理成本较高。开源软件间安全漏洞、后门风险的连锁传播，须进行有效漏洞管理。

#### 对外参予和对外开源程度不足

金融机构整体上在开源产业生态链中贡献度较低。传统银行科技团队面的挑战更多，对外开源的内部流程更复杂、孵化时间更长。

#### 开源供应链风险层出不穷

随着软件供应链开源化趋势日益明显，供应链风险也随之愈发复杂和多样化，主要包括了断供风险和攻击风险。

### 4.1.3 金融行业开源发展前景与趋势

#### 和开源供给侧合作更加紧密

金融行业开源已广泛应用，开源软件方面的专业服务需求日益旺盛，和开源商业公司、开源技术服务公司、开源软件安全服务公司、开源治理咨询公司的合作将更加紧密。

#### 生态共建步伐进一步加快

金融行业在《意见》的指导下，在北京金融科技产业联盟开源专委会的组织下，通过FOST平台和OFTP平台，将进一步分享开源技术应用经验，共享开源技术研究成果。通过各类团体，如金融行业开源技术应用社区（FINOC）和经溶液开源技术应用与发展实验室，行业合作共建步伐将进一步加快。

#### 对外开源意义进一步普及

各类机构在开展生态共建的基础上，将进一步了解对外开源的意义并逐步熟悉对外开源能力建设方法。

### 4.1.4 金融行业开源发展建议

#### 金融机构应合理制定开源规划

金融机构应在IT顶层规划设计，加强开源软件使用、开源治理、开源人才队伍建设方面的规划，实现开源核心技术的自主可控。

#### 金融机构应加强开源安全管理

金融机构应加强开源风险意识，提升开源工作认知度和参与度，建立统一安全管理机制，破除开源引入障碍，规范开源全生命周期管理，推动适合开源的组织架构调整，指导金融机构建立开源办公室，配备相应的开源法律合规团队，彻实掌握开源使用规模、复杂度，对已存在的安全漏洞、许可证合规风险主动防控处理。

#### 金融机构应积极参与开源生态建设，加强开源社区互动

金融机构应走出以使用为主的单方模式，在贡献开源、主动开源、开源慈善捐赠等方面主动投入和布局，加强与协会、联盟、基金会等社会组织合作和开源社区互动，推动开源供给侧参与金融开源工作，积极参加编制开源标准，促进金融行业开源生态可持续健康发展。

## 4.2 开源在汽车行业的应用

> 作者：滕召智，OpenSDV汽车软件开源联盟生态负责人
>
> 参与单位：极氪汽车、长安汽车、信通院、国科础石、中汽智联

### 4.2.1 2022-2023全球汽车软件开源生态

2022年，汽车行业的战略技术储备通过成本及供应链的棱镜，在市场表现上展露的非常明显，技术架构也随着软件比重以及EE架构进入了新的双螺旋进化模式。目前各个车企，根据自身供应链条件的不同，也正处于不同的发展阶段。软件定义汽车正在通过软件的技术、基础技术的普及、科技团队的引入影响汽车行业，促使整个行业进入到一个新的发展阶段。

![](https://img-blog.csdnimg.cn/69401728393a4f3284727b8731b2bc5f.png#pic_center)

基于以上的行业发展趋势，软件的比重在汽车研发时间以及成本上均上升迅速，据麦肯锡的预测，到2030年软件的比例将达到30%。2025年汽车软件的市场规模将达到620亿美元，尤其是网络，车用芯片，V2X架构以及云端基础设施的完善，“硬件预置、软件解锁”的产品策略将会出现在汽车的多个功能域中。

![](https://img-blog.csdnimg.cn/8b3d89bcf75b4a1d8603c64c364656ec.png#pic_center)

![](https://img-blog.csdnimg.cn/74e51398ba9e4cb28cf37c0c255f2f5f.png#pic_center)
 
要做好灵活的上层架构，需要在性能强大的硬件架构基础上，有一个“可编程” “安全成熟” “生态丰富”的车用操作系统。因此，车用操作系统成为车企核心竞争力的基石，我们在与多家车企沟通后发现，由于底层操作系统的投入巨大，产出不明确，现在大多数车企还是采用了商业化的成熟产品，比如QNX、VXWorks等，成熟产品的好处是可以非常高效的完成汽车的研发。但这些都基于相对固定的供应链体系，如果想要在产品设计上有丰富的扩展性和灵活性，使用商业软件，需要付出昂贵的成本以及可能存在的供应链被控风险，因此，还有很多厂商，投入了巨大的研发进行“全栈自研”，鲜有成功的案例。

从产业角度来看，需要有一种方式联合操作系统的硬件环境，需要熟悉操作系统的科技公司和科研机构进行合力共建，对产业共性的问题进行解决，当然，还有很多的中间件以及工具，也是重要的基础软件。2022年涌现了非常多的组织，例如OpenSDV、Eclipse的SDV工作组，中国智能网联汽车产业创新联盟的基础软件工作组等等。大家都在寻求一种新的共建模式，需要有一定的组织形式，有共同的代码共享存储，有活跃的参与者组成的社区，这就是产业需求衍生的开源模式。

汽车因为供应链很长，涉及面非常广，汽车软件的复杂度也很高，从本次调研的情况来看，我们非常高兴的看到了车企与开源的交织，也看到了很多的问题。我们这一次先从大多数车企所处的开源阶段 --- 合理使用开源进行展开。

同时，随着开源软件的引用、供应商大量使用开源中间件或组件进行交付，在车企进行SBOM管理时迎来了巨大的挑战，需要有一个跨部门、跨组织、跨权限的协调组织出现，进行资源、流程的配置与管理，因此，开始引入了OSPO（Open Source Program Office），这在大型互联网企业相对成熟，对于企业在使用外部开源组件/项目的合规，以及代码开源到外部的流程负责，协调研发、产品、市场、法务、人力进行综合的管理，在用好开源的同时，也遵循开源世界的游戏规则，更好地融入其中。比如在2022年7月，极氪汽车成立了自己的OSPO，取名为极氪开源合规审查小组。在同期，长安也正在考察开源软件办公室的作用和意义，最终还是以知识产权相关部门为驱动，在合规上进行把关。

### 4.2.2 问题、机遇与挑战

从当前的生产模式和电子电气架构在大多数车厂的发展阶段，车企在整体开源生态上，还是一个使用者的角度，Tire1和Tire2厂商在基础技术的投入、技术要更深入。从车企以及软件供应商和集成解决方案的提供商来说，需要从引入开源软件或组件入手，逐渐规范起来，迎接开源带来的无限可能，也正视可能的风险。

#### 开源合规与供应链安全

根据新思科技发布的《2023年开源安全和风险分析》报告，2022年，在汽车所在领域（航空航天/汽车/运输和物流），100%的代码库包含开源代码，开源代码占所有代码的73%；65%左右的代码库包含许可证冲突（远高于全体样本的53%）；63%的代码库包含高风险漏洞（远高于全体样本的48%）。

2022年9月，美国发布了备忘录（M-22-18）《通过安全的软件开发实践增强软件供应链的安全性》，欧盟发布了提案《关于具有数字元素的产品的横向网络安全要求》（《网络弹性法案》），对软件安全提出了相关要求，涉及符合性声明、软件材料清单（SBOM）、漏洞处理流程、第三方评估等多个方面。

##### 美国：备忘录（M-22-18）《通过安全的软件开发实践增强软件供应链的安全性》

2022年9月14日，美国总统办公室签发了备忘录（M-22-18）《通过安全的软件开发实践增强软件供应链的安全性》[1]。基于2014年《联邦信息安全现代化法案（FISMA）》和2021年总统行政命令（EO 14028）《提高国家网络安全》[2]的要求和授权，该备忘录要求每个联邦机构在机构的信息系统上使用第三方软件或以其他方式使用第三方软件影响机构的信息时，遵守NIST指南和任何后续更新。其中，“NIST指南”是指美国国家标准和技术研究所（NIST）2022年发布的（SP 800-218）《安全的软件开发框架（SSDF）》[3]（1.1版）和《软件供应链安全指南》[4]两个文档，用以确定增强软件供应链安全性的实践。

如NIST指南中所述，联邦机构只能使用那些能够证明遵守政府规定的安全的软件开发实践的软件生产商提供的软件。各联邦机构必须获得所有本机构使用的该备忘录要求的第三方软件的证明，即NIST指南所述的需要软件生产商提供的“符合性声明”（conformance statement）。这些要求适用于联邦机构对该备忘录生效日期后开发的软件的使用，以及对该备忘录生效日期后通过重大版本变更修改的现有软件的使用。该备忘录中的术语“软件”包括固件、操作系统、应用程序和应用服务（例如基于云的软件），以及包含软件的产品。

![](https://img-blog.csdnimg.cn/8fea9b775bb64f219d2ebb838c41bc37.png#pic_center)
 
根据该备忘录，符合性声明的最低要求包括：

1. 软件生产商的名称；
2. 对声明所指的一种或多种产品的描述（最好集中在公司或产品线层面，包括销售给联邦机构的所有未分类产品）；
3. 证明软件生产商遵循标准自我证明表格中列举的安全开发实践和任务的声明；
4. 自我证明是所需的最低级别；但是，根据备忘录（M-21-30）《通过增强的安全措施保护关键软件》[1]中的界定，由于所采购的服务或产品的关键性，机构可以做出基于风险的决定，即需要进行第三方评估（第三方评估组织需要经FedRAMP或联邦机构认证批准）。

此外，对照EO 14028的要求，NIST指南中也对符合性声明给出了更为详细的实践参考，主要涉及组织准备（PO）、软件保护（PS）、安全软件生产（PW）、漏洞应对（RV）四个方面。

其中，在M-21-30里NIST对“关键软件”的界定如下：

关键软件，是指任何具有或直接依赖于一个或多个具有以下至少一种属性组件的软件：

- 旨在以较高的权限或管理权限运行；
- 对网络或计算资源有直接的或特许的访问权；
- 旨在控制对数据或操作技术的访问；
- 履行对信任至关重要的功能；或者
- 在正常信任边界之外使用特许访问进行操作。

该定义适用于为信息系统购买或在信息系统中部署并用于操作目的的所有形式的软件（例如，独立软件、特定设备或硬件组件的集成软件、基于云的软件）。

根据备忘录的要求，对于“关键软件”，除了需要提供第三方评估证明外，还需要提供软件材料清单（SBOM）。受EO 14028的指示，美国商务部与国家电信和信息管理局（NTIA）在2021年发布报告《软件材料清单（SBOM）的最低要素》[2]，对SBOM的要求进行了详细的说明。在该报告中，SBOM的最低要素被概括为三个方面：

<table>
    <tr>
        <td colspan="2">最低要素</td>
   </tr>
    <tr>
        <td>数据字段</td>
        <td>记录应该跟踪的每个组件的基准信息：供应商、组件名称、组件版本、其他的唯一标识符、依赖关系、SBOM数据作者、时间戳。</td> 
    </tr>
    <tr>
        <td>自动化支持</td>
        <td>支持自动化，包括通过自动生成和机器可读性以支持在跨软件生态系统中扩展。用于生成和使用SBOMs的数据格式包括SPDX、CycloneDX和SWID标签。</td>
    </tr>
    <tr>
        <tr>
        <td>实践和流程</td>
        <td>定义SBOM请求、生成和使用的操作，包括：频率（版本更新）、深度（所列组件的层次范围）、明确的未知（依赖关系是否已穷举）、分发和交付、访问控制、容错。</td>
    </tr>
</table>
	
##### 欧盟：提案《关于具有数字元素的产品的横向网络安全要求》（《网络弹性法案》）

目前生效的相关欧盟立法，包括从不同角度处理与网络安全相关的某些方面问题的规则，例如改善数字供应链安全的措施，但缺少横向的联盟监管框架为所有具有数字元素的产品确立全面的网络安全要求，也没有解决非嵌入式软件的网络安全问题。2022年9月15日，欧盟发布了提案《关于具有数字元素的产品的横向网络安全要求》，即《网络弹性法案》（Cyber Resilience Act）[1]，从而为具有数字元素的产品投放欧盟市场的基本网络安全要求制定一个统一的法律框架，并消除商品自由流动的障碍。

该法案主要规定了：

1. 将具有数字元素的产品投放市场的规则，以确保此类产品的网络安全；
2. 设计、开发和生产具有数字元素的产品的基本要求，以及经营商[2]在网络安全方面对这些产品的义务；
3. 制造商为确保具有数字元素的产品在整个生命周期中的网络安全而制定的漏洞处理流程的基本要求，以及经营商在这些流程中的义务；
4. 市场监督规则以及上述规则和要求的执行。

该法案适用于具有数字元素的产品，其预期或可合理预见的用途包括与设备或网络的直接或间接的逻辑或物理的数据连接。其中，“具有数字元素的产品”是指任何软件或硬件产品及其远程数据处理[3]解决方案，包括单独投放市场的软件或硬件组件。此外，关于网络和信息系统安全的指令（EU）2016/1148（NIS指令）修订产生的指令NIS2，将确保对于作为服务提供的软件（软件即服务）的设计、开发和漏洞处理，也实施类似于《网络弹性法案》的基本网络安全要求的技术规范和措施。

![](https://img-blog.csdnimg.cn/6a9568bdefb847059ec6d043c3cdca92.png#pic_center)

在这种情况下，即使没有海外法规的倒逼，我们也应该关注到使用或应用开源可能存在以下风险：

- 可能会有安全漏洞；
- 可能在整合过程中出现Bug；
- 可能存在潜在的合规性问题,例如许可证和出口管制风险；

针对上述几个现状问题，开源软件的规范化使用以及合理的开源协议的使用，要尽可能地减少风险以及为应对海内外法案做好前置准备：

- 合理地建立开源组件的白名单机制，从可信的托管服务商或基金会取得高质量、有限的开源组件；
- 增加对于公司开源加密算法数据库管理的要求，以及加密算法审查备案机制；
- 安全团队记录使用的组件来源，做好SBOM动态采编，并跟踪组件的漏洞报告，明确和优化组件选型和进入流程；
- 法务团队了解该组件的法律合规需求，并提出风险建议，目前企业在开源软件的合规性问题上，主要关注许可证风险和出口管制风险。前者主要是开源风险、知识产权风险、对外展示风险。后者在于开源加密算法的使用；
- 通过组建专门的或虚拟的OSPO团队，从各部门协助监控整个流程的执行；
- 在对外输出服务或发布软件时，工程师可以根据组件来源快速梳理使用的开源组件清单，并明确当前版本的漏洞闭合以及协议使用情况，了解最优及最糟的安全状态，可以高效地应对安全/合规的不同场景输出；

为了更好地推动汽车行业软件供应链安全体系建设，我们近期与业内相关软件供应链安全机构开展了深入的沟通和交流，各方对汽车软件供应链安全体系的建设想法高度一致，计划接下来共同推动以下工作：

1. **标准建设：** 建设汽车行业与OpenChain ISO/IEC 5230兼容互认的开源合规企业认证标准，对企业的开源软件使用、管理、输出进行定义，同海外组织开展对话，并进行协议保护措施；
2. **检测认证体系建设：** 建设汽车行业开源软件供应链检测认证体系，推动与海外评测要求兼容，与海外检测机构互认，避免企业在出海时重复检测和投入。同时，通过建设标准检测认证体系，也将为中国加强对进口汽车的软件安全检测提供可参考的标准和方法； 
3. **公共服务平台建设：** 建设汽车行业的SBOM标准和登记查询平台，相关组件及软件库白名单体系以及漏洞库同步机制，为车企提供可自查及要素引用的公共服务平台；
4. **应用落地：** 关注海外相关政策法规发展，例如欧美政策法规中提到的关键软件和主要信息要素；推动汽车行业软件供应链安全相关规范建设，例如在安全等级评定标准中，信息要素登记系统明确要求记录使用的开源软件的名称、版本、来源，便于出现漏洞时进行预警以及自审自查自纠，并与漏洞库、软件版本跟踪数据库相连。

需要与相关机构合力，共同推动汽车行业软件供应链安全相关的体系标准和基础设施建设，促进行业健康发展，为中国车企出海提供开源合规支持。

#### 新技术探索

GPT(Generative Pre-trainedTransformer))技术在多个车企内部的SOA中均有所提及，除了从应用端解决类似智能客服的问题外，如果可以训练GPT参与到代码编写过程，不仅可以规范化和模块化可靠的代码块，也可以尽可能减少人为错误。通过GPT将具有功能安全不同等级要求的代码风格，结构和关系树结合到开发流程中，开发满足功能安全要求或者适用于汽车座舱环境的代码。要达到这样的效果，需要对模型进行大量的训练，给予正确的边界理解，让GPT可以在汽车这种垂直领域的软件开发中贡献力量。这里也不可避免的需要参与单位通过开源、开放的形式，在数据样本、编码要求上进行共享，促进整体行业的技术进步。

### 4.2.3 主要问题的解决思路及建议

#### 产业的技术更迭太快，人才的储备不足

通过调研，最近5年的汽车行业技术更迭，超过了过去十五年的综合，智能汽车，新能源智能汽车，对于汽车行业的人来说，需要学习和了解软件技术，而熟悉软件技术的人，极少有熟悉汽车这种垂直行业的，因此现在人才的引入、培养、梯队都非常有挑战。

但通过开源，或许是过渡时期解决人才短缺的一个可行路径：

- 芯片企业通过低成本的模拟仿真工具，让开发者，尤其是学生开发者可以尽早的进入到这样的开发环境；
- 车企需要通过联合实验室的形式，将汽车所需要的技术以课题抛出，让开发者可以早日接触到真实需求；
- 科技企业需要引入和参与到Tire1和车企，完成对产业的理解；
- 开源开放，多鼓励汽车相关领域的开源社区，以不同的主题，给跨界的人才寻找也就方向，逐渐形成大的生态。

#### 合规使用开源，需要车企重视

无论是外部的逼迫，或者是我们从开源生态的建设来看，都需要建设规范的使用和参与开源。在出海的需求驱动下，车企和软件供应商等需要开始储备SBOM或者相关的管理措施，

需要发出源自中国供应链体系的声音，破解很多年的规则和要求

底层系统的兼容性，以及外部工具软件的硬件清单，其实就是汽车供应链角度的朋友圈，国内鲜有企业能够参与决策，需要通过底层系统的开源，构建和发出可控供应链体系的声音。另外，在功能安全角度，车用系统已经发生了架构上很大的变革，但是现在的判断标准还停留在几年前。我们可组织产业内的企业共建，在国际汽车供应链体系内发出声音，也通过生态企业的广泛应用，形成事实标准，推进团标、国际标准的更新迭代。

参考文献：

- https://www.whitehouse.gov/briefing-room/presidential-actions/2021/05/12/executive-order-on-improving-the-nations-cybersecurity/
- https://www.whitehouse.gov/wp-content/uploads/2022/09/M-22-18.pdf
- https://digital-strategy.ec.europa.eu/en/library/cyber-resilience-act https://csrc.nist.gov/Projects/ssdf
- https://www.nist.gov/system/files/documents/2022/02/04/software-supply-chain-security-guidance-under-EO-14028-section-4e.pdf
- https://www.whitehouse.gov/wp-content/uploads/2021/08/M-21-30.pdf

## 4.3 开源在工业互联网的应用

> 作者：郑伟波，浪潮国际CTO、开放原子基金会TOC副主席

### 4.3.1 2022-2023年工业互联网开源发展现状

工业互联网自2017年上升为国家战略以来，在政策与市场双轮驱动下，呈现快速发展态势，国家级双跨平台从最初的10家已经发展到29家，面向行业和专业领域的工业互联网平台更是达到几百家，体系架构也从1.0进化到2.0，功能视图体系架构如下：

![](https://img-blog.csdnimg.cn/3d95b467bb0f4997b400b60420d57795.png#pic_center)

<center>工业互联网功能视图平台体系框架</center>

工业互联网高速发展，部分功劳应归功于开源软硬件的助力。目前，工业互联网通用技术领域开源项目较多、成熟度相对高，但不可忽视的是，深入到OT层、传统制造领域，开源项目相对少、成熟度也较低，且核心开源项目以国外为主。推动开源开放技术体系，对加快我国工业互联网发展具有重大意义。近年来，我国也涌现了一批优秀的工业互联网开源项目，整体呈增长态势。

#### 工业互联网边缘侧碎片化程度高，开源技术发展空间广阔

工业互联网边缘侧主要是通过物联网技术实现工业设备数据接入能力、协议解析与数据预处理，整个服务市场呈现碎片化的形态，为开源技术提供了更广阔的发展空间。从通信网络、连接协议到物联软件、时序数据库，都存在大量优秀开源项目，我国开源项目表现也相当亮眼。

在网络方面，5G开源项目较多，包括Open5Gs、Free5GC和Magma等，NB-IoT、LoRa、ZigBee等相对少。在连接协议方面，MQTT、CoAP、OPC UA、AMQP、XMPP、DDS等都是开源协议，基于标准协议的开源项目也较多，其中，中国的开源物联网 MQTT 服务器EMQX的全球下载量已超千万。工业协议方面，由于传统工业厂家的市场格局和商业利益，大多数工业协议都是封闭化设计，较少开源。在物联软件方面，从组件到整个平台软件都有典型开源项目，包括消息队列Kafka、Pulsar，规则引擎Node-RED、EMQ X IoT Rule Engine，开源物联网平台ThingsBoard、IOT DC3、Kaa等。此外，为了物联网边缘计算构建通用开放框架，2017年6月，Linux基金会主持成立开源边缘计算框架EdgeX Foundry，提供开源微服务的集合，用于统一工业互联网边缘计算解决方案的生态系统。在时序数据库方面，近几年一直处于高速发展阶段，开源项目更是层出不穷，权威排名DB-Engines TimeSeries热度前五中，包括第一名InfluxDB在内的4个都是开源项目，国内的开源时序数据库TDengine、Apache IoT DB排名也比较靠前。

#### 开源生态极大推动了云资源管理领域主流技术的更新迭代与快速应用

以微服务、容器化为代表的云原生技术架构被认为是工业互联网云资源管理的最佳选择。相较于传统的虚拟化技术，基于容器和Kubernetes的云原生解决方案在简化应用部署、重组微服务能力、建立云边一体化资源调度等方面具有敏捷、灵活、高效率的技术优势。

纵观过去几年云原生技术的发展历程，开源为云原生技术带来了前所未有的发展浪潮，极大的加速了云原生在全球范围内快速应用。2015 年云原生基金会 CNCF 成立，为云原生在全行业广泛应用奠定了基础，拥有上百个全球开源项目。云原生开源项目从早期开源的容器引擎项目 Docker出发，不断扩展应用领域，对边缘、异构等各类场景的适配能力不断深入，包括Google开源的容器编排引擎Kubernetes，已经成为了容器编排领域的事实标准；开源的监控告警系统Prometheus，已经成为了云原生监控领域的事实标准；开源的服务网格框架Istio，提供了流量管理、安全、可观察性等功能，已经成为了服务网格领域的事实标准。

全球云计算厂商都在积极布局云原生开源项目，国内也涌现出大量的优质开源项目，包括腾讯开源的微服务框架TARS、阿里开源的容器镜像仓库项目Harbor 已经从 CNCF毕业。可以看出，开源社区是云原生技术的创新根据地，是加速云原生与行业融合、推动各行业创新的助推器。

#### 工业应用开发环境逐渐转向低代码模式，开源项目正在兴起

工业互联网的价值在于重构工业知识创造、扩散、复用新体系。工业知识往往掌握在专业技术人员手中，低代码、零代码的工业应用开发环境为这些技术人员提供一个标准化、易用的编程环境，通过统一的编程语言，实现流程、逻辑、经验、算法、规律等工业知识的快速封装，已经成为填补技术人员的开发技能的有效工具。

目前，国内低代码、零代码创业型公司和产品众多，开源项目较少，正处于兴起阶段。百度开源了amis前端框架，阿里巴巴开源低代码引擎LowCodeEngine。浪潮开源低代码内核UBML，并发布了具有完整企业级应用能力的海岳低代码平台inBuilder社区版。虽然国内低代码平台目前取得了很多不错的成果，在低代码平台开发类型上对OT类应用仍支撑不足，期待开源社区带动在这方面的持续深化发展。

#### 工业数据管理领域以开源为主导，多种技术和架构并存

工业数据管理与服务通过大数据技术提供面向海量工业数据提供数据治理、数据共享、数据可视化等服务，是工业互联网发挥工业大数据价值的重要一环。大数据技术与开源之间有着密不可分的关系，目前市场上应用最广泛的大数据技术栈还是以开源大数据框架Hadoop与开源通用内存并行计算框架Spark为核心的生态系统。

近年来，以Hadoop为核心的开源大数据体系，逐渐向多元化技术并行发展。一方面，原有Hadoop体系的产品迭代趋于稳定，一些常见的开源组合，比如 Flink+Kafka、Spark+HDFS 等，经过开源生态市场的检验，已经成为相对固定的标准化选择。另一方面，大数据技术生态也在向流处理、数据可视化、交互式分析等方面探索，例如，近几年流行的开源大数据可视化工具 Apache Superse。随着云原生的发展，与云原生结合更紧密的 Airbyte、Flink CDC、 SeaTunnel、 InLong 等项目也得到了飞速发展。《2022开源大数据热力报告》显示，云原生数据集成在 2018 年超越了传统数据集成。

#### 工业数字化工具成熟开源项目少，主要集中在欧美发达国家

工业数字化工具融合数字建模、数字仿真、数字孪生等技术，提供产品、设备、工艺和系统的三维设计、仿真、展现、优化等，是工业自主可控的关键，是工业互联网的重要工具，其中，几何内核、约束求解器、3D引擎是工业数字化工具核心技术，属于高技术含量、高研发投入、高应用门槛产业，成熟技术高度集中在欧美发达国家。

目前全球市场上只有少数内核厂商，其中，CGM、ACIS、Parasolid、Granite属于第一梯队，分别属于法国达索（前两个）、德国西门子、美国PTC，这些技术虽然闭源，但应用广泛；Open CASCADE（OCC）是目前世界上为数不多的开源几何内核，由法国Matra Datavision公司开发，基于OCC的CAD软件有FreeCAD、HeeksCAD、AnyCAD等。

在约束求解器方面，西门子的DCM是全球最成功的商用几何约束求解器，处于垄断地位，其他还包括达索的CGM、俄罗斯LEDAS的 LGS，知名度也较高。因此市面上的开源约束求解器也众多，但是大多数是限定于某些细分领域或来自于研究性项目，例如OpenFOAM、FEniCS、Elmer、Salome-Meca等。

在3D引擎方面，国内开源项目处于空缺状态，目前主流的引擎包括商业引擎Unity Technologies公司的Unity，和开源引擎Epic Games公司的UE、Analytical Graphics公司的Cesium、Mr.doob个人开发的Three.js等，其中，UE以逼真的渲染效果著称，在游戏开发中应用较多，工业领域也有一些项目在应用UE；Unity、Cesium、Three.js在工业领域应用较广泛。

#### 国内积极探索工业模型开源开放，促进工业知识的沉淀、复用和迭代创新

工业互联网的核心资源是工业模型，即工业知识的模型化、标准化表达。工业模型的跨系统流转、交付、应用，极大的促进了工业知识的共享与发展。统一建模语言具有领域无关的通用模型描述能力，基于统一建模语言的方法能够实现复杂系统的不同领域子系统模型间的无缝集成。欧洲仿真协会EUROSIM于1996年推出多领域统一建模语言Modelica，经过多年发展，目前Modelica标准库已经包括了不同物理领域的1600多个模型组件，基于Modelica发展出来的商业软件、开源软件也非常多，Modelica模型可以在这些软件中自由流转。除了Modelica外，工业界大部分成熟的建模工具都建有自己的模型库，例如Simulink 建模工具在产业界、学术界被广泛应用，自带对象模型库、算法库、控制系统、环境模型、基础元器件模型库等，但这些模型并不是免费开放的。国内工业互联网发展始终提倡加速工业知识的沉淀、复用和迭代创新，其中，同元软控通过打造工业知识模型互联平台MoHub，构建了一个覆盖函数库、模型库、APP库服务的模型社区，开发者以开源方式分享到社区的模型库，支持海量用户参与到工业知识模型的开发、分享、创新应用过程。

#### 工业APP基于应用商店模式加快开源开放步伐

工业APP是基于工业互联网，承载工业知识和经验，满足特定需求的工业应用软件，本质是企业知识和技术诀窍的模型化、模块化、标准化和软件化。开发者社区是开发工业APP的主要推动力，平台和微服务框架降低了工业APP开发的难度和门槛，大量的开发者都可以参与开发工业APP。面向特定工业应用场景，激发全社会资源形成生态，推动工业技术、经验、知识和最佳实践的模型化、软件化和封装，形成海量工业APP。

应用商店是向企业用户提供的工业APP分发渠道，是促进工业APP应用生态繁荣发展的有力支撑。在应用商店模式下，来自不同制造商的工业APP可以跨平台运行，相互交互，具有一致的语义，按照共同的标准工作，并且对所有社区开发者开放。目前开发工业APP的核心技术主要由国外公司把控，国内整体开源产品较弱。开源可成为颠覆传统工业APP的重要武器，国内企业开始布局探索，开源意识逐渐增强，传统优势企业和创新性企业加快开源布局。在应用商店模式下形成开放的应用程序生态系统后，工业APP领域会向传统PC软件市场一样取得蓬勃发展。

#### 开源工业软件成果丰富，国内积极探索破局之路

工业软件是工业互联网的核心力量，近年来均涌现了大量开源工业软件。在研发设计类软件方面，有开源免费的用于3D建模的FreeCAD、2D建模QCAD社区版以及基于QCAD的一个开源分支发布的LibreCAD等开源软件。目前开源CAD软件供个人使用表现的比较出色，但仍然无法在大型企业直接代替AutoCAD 的直接模拟。在工业设备中常见的生产控制类软件可编程逻辑控制器（PLC）方面，OpenPLC、Beremiz、Apache PLC4X等都是非常优秀的开源PLC软件。开源的ERP、CRM类业务管理软件数量也已形成规模化生态，如Odoo。我国工业软件在国家的大力扶持以及各类企业的不懈努力之下，发展步伐明显加快，但仍存在高端工业软件缺位、本土工业软件应用困难等问题。工业软件的破局之路艰难，开源不失为一种新的思路。2022年7月，开放原子全球开源峰会成立OpenAtom openCAX工作委员会，在开源领域布局了一批共性关键技术，联合构建OpenDACS开源EDA平台，聚集国内优势力量，共同探索工业软件发展新路径。

#### 工业互联网开源社区整体发展良好，与实际产业联系仍需加强

目前工业互联网领域应用比较广泛的开源项目，其社区发展也比较活跃，如Eclipse IoT、Linux Foundation、OPC Foundation、FreeRTOS、Zephyr等。其中，Eclipse IoT提供了基于Eclipse的开源工具，包括开发工具、测试工具、运维工具等，这些工具都能够支持工业领域的物联网应用开发和测试。Eclipse IoT的社区正在快速成长，145+的创新组织都致力于加速采用由 Eclipse IoT 社区开发的商业级、生产就绪的开源技术。OPC Foundation推动了OPC UA协议的发展和普及，积极参与了各种工业物联网协议的制定，提高了标准的普适性和实用性。仅2019-2022年，OPC Foundation基金会成员就增加了150多名。截至目前，全球已有超过 920 家 OPC 基金会成员和数千个符合 OPC 标准的产品。

但是，许多其他工业互联网领域的开源项目，由于没有形成实际的产业应用，发展相对滞后，仍需要进一步改进与完善。如EdgeX Foundry项目，由于其与实际工业应用场景不够贴合，该项目会员数发展至今仍低于100，且在GitHub上仅三十多人贡献了代码仓库。

### 4.3.2 工业互联网开源发展的问题与挑战

工业互联网开源要得到长足发展，必然面临开源领域普遍会遇到的供应链风险、代码安全风险、知识产权风险、自主创新风险，同时，还要解决自身领域存在的开源发展问题与挑战。

#### 平台层工具软件开源运营成本高、传统商业模式获利难

工业互联网平台发展迅速，国内头部厂商纷纷搭建了双跨平台，我们仔细研究这些平台，就会发现重要部件几乎都用到了开源软件。但平台型软件商业巨头，往往体量大，在市场竞争中处于优势地位，通过采用开源软件、工具搭建商业工业互联网解决方案，实现快速推广并获利，而这些开源软件、工具的创新型厂商由于体量小、整合能力有限，没有提前布局商业，再加之开源运营成本高、难以获利，往往给别人做了嫁衣，自身发展后劲不足，长此以往不利于工业互联网基础软件开源生态发展。

#### 工业互联网技术门槛高，跨大量开源组件构建平台往往导致深度整合和优化不够

工业互联网融合OT、IT、CT等多个领域技术，实现深度整合和优化是一件非常复杂且困难的事情，开源项目在这方面存在非常多的市场机会，开源软件、工具可以免费获取源代码，对于有一定IT能力的企业来说，具有较好的经济效益。例如大部分软件厂商、工业企业往往会选择Kubernetes、Istio、Docker等快速搭建工业互联网平台。开源软件虽然使用简单、经济，但往往也面临着“免费即最贵”的尴尬局面，开源技术的大规模商用需要充分的评估与实践，需要技术团队同时掌握很多不同领域的开源组件，并且能融会贯通、知道如何将这些组件更好地组合到一起。但大部分中小软件厂商或传统企业没有足够的专业人才，缺少融合多个开源软件系统的一整套解决方案，往往面临因软件版本不统一的兼容问题、因参数配置不合适的性能问题、因缺少技术支持的运维优化困境，导致深度整合和优化不够。

#### 工业互联网各子技术领域开源发展不均，缺乏核心工具的开源

工业互联网边缘层、PaaS层、应用层，由于各层功能与技术差异，其开源发展不均，国内更是少见核心工具的开源。边缘层主要提供协议解析、工业数据接入及预处理等能力，国内外开源项目较多，如设备网关接入方面有NEURON、MQTT、ThingsBoard、EMQX等开源项目，但受制于工业协议的多样性，多数开源项目都无法做到协议适配的通用性。PaaS层主要提供工业数字化工具、工业数据管理服务、工业模型管理服务等工具及通用能力，因商业用途及专业工具的技术门槛高，厂商往往选择封闭发展，构建技术壁垒，核心开源项目较少，尤其三维设计、仿真优化。不过，近几年随着Open CASCADE等开源数字化工具的出现，逐渐打破了AutoCAD等主流封闭软件的垄断局面。应用层方面，传统研发设计类软件、生产控制类软件、业务管理类软件和工业数据软件中，均涌现出了大量开源软件，如开源ERP Odoo、Apache基金会旗下的Apache OFBiz项目，已经有了较大的应用生态。但从整体发展来看，工业设计类软件、工具仍需加强布局。

#### 边缘侧工控系统、协议相对封闭，影响设备的互联互通

边缘侧工控设备（PLC、DCS等）以及工控协议经过20年间的发展，一方面激烈的市场竞争刺激了西门子、施耐德、欧姆龙等国际厂商产品快速迭代升级，另一方面也构筑了设备互联互通的壁垒，各家厂商所采用的PLC编程和通讯交互方式不尽相同，衍生出不同类型的通信协议，虽然极大的增强了自身向上层的数据传输能力，但这些协议大部分是采用封闭设计，彼此不兼容，用户无法扩展或自定义系统、协议以满足其特定需求。

目前边缘侧工控系统、协议的开源程度虽然不是很高，但还是有一些有影响力的开源项目，例如，OpenPLC是一个开源的可编程逻辑控制器，Open Industrial Linux是一个基于Linux的开源工业操作系统，还提供PLC、HMI工业自动化应用程序。

### 4.3.3 工业互联网开源发展前景与趋势

当前，开源已成为工业互联网领域的重要开发模式，工业互联网各技术领域越来越多的采用开源代码，自身的开源化趋势也越来越明显。工业互联网开源正在向垂直行业解决方案、海量工业APP、工业技术为主的OT层渗透。

#### 工业互联网依托开源社区与生态发展垂直行业解决方案

我国石化、钢铁、电子信息、家电、机械、汽车、装备、航空航天等垂直行业广泛应用了工业互联网技术能力。各垂直行业的工业互联网实施业务场景相对独立、应用领域不尽相同，应用深度参差不齐，实施路径也存在差异，如何打造更多的垂直行业解决方案，将单独部署的工业互联网项目拓展和融合达到行业规模化，是工业互联网高速发展必须解决的问题。

开源社区可以使跨地区、跨领域的专业人才之间通过开放式的创新生态实现深度交互与智慧共享，让更多的人参与到垂直行业解决方案构建中，从而提高项目的数量和质量。面向垂直行业的工业模型、插件类开源项目将逐渐增多。

#### 工业APP需求繁杂，低代码工具开源能够加速创新效率

工业APP涉及研发设计、生产制造、运维服务和经营管理等不同领域与环节，个性化强，对象众多，关系非常复杂，体系庞大且需求繁杂。低代码开发工具沉淀过去十几年策划、开发、应用工业APP的经验，参考工业产品制造模式形成一些典型模型和架构模式，提供低门槛应对复杂需求的开发方案。

低代码开发工具通过生态联盟，由多家企业专注其擅长的部分，彼此协同发展，可以不断积累工业APP模式，构建领先的产业集群。开源是建立这个生态联盟的有效方式，通过开放源代码，聚集各个行业工业APP的领先厂商，彼此打通、串联，共同推动沉淀工业软件、智慧城市、智能制造等领域的低代码模型，应对繁杂的工业APP需求，提供低门槛开发方案，加速工业互联网领域创新效率。

#### 工业互联网技术开源由IT层迈向OT层

IT层主要涉及计算机、互联网、应用软件等，其软件系统相互连接，通常运行在iOS和Windows等流行的操作系统上，缺乏自主性，软件开发规范、使用标准解决方案以及流行的通信协议，应用场景广泛，因此开源项目较多。相比之下，OT层主要涉及机械、工控网络、工控系统以及跨工业协议的通信，系统一般是自治的、隔离的、自包含的，运行在专有软件上，与传统计算机编程不同，应用场景也涉及更多专业知识和技能，因此OT层开源项目一直发展缓慢。

随着IT与OT融合越来越深，OT层也开始寻求标准化的发展道路，IT与OT之间的界限正在被引入连接设备的OT系统和物联网的兴起所模糊，OT层的开源项目也会逐渐增多。

#### 工业互联网通过开源社区培养专业人才

工业互联网领域开源项目蓬勃发展，开源软件的易获取性让众多高校学生、企业人才可以低成本的接受并使用开源软件，同时开源社区中汇聚了众多有着开源精神和探索精神的开源贡献者，开发者可以在社区中获取到软件源代码、与更多的业内优秀从业者进行协作、扩充个人技术图谱和技术栈等，因此开源社区也成为了工业互联网领域人才培养的重要基地。

高校是人才培养的重要来源，高校学生也可以通过开源社区开拓技术视野，锻炼协作能力。通过一系列的开源校园行活动可以有效推进开源文化、开源实践在高校的普及，促进高校开源人才培养、加强高校人才参与到企业开源实践，为工业互联网行业提供源源不断的人才供给。

### 4.3.4 工业互联网开源发展建议

#### 鼓励龙头厂商积极参与工业互联网开源发展，布局重点领域的开源项目

工业互联网龙头厂商是产业技术创新的主要推动者，是产业高质量发展的重要依托。工业互联网龙头厂商应积极发挥产业创新过程中的融通引领作用，参与开放原子开源基金会组织的重点开源活动、开源项目，共同营造良好的工业开源文化氛围，开展产业开源顶层设计与总体规划布局，打造中国工业互联网顶级开源社区，组织引导产业链上下游企业围绕核心技术领域孵化CAX、PLC等优质工业互联网开源项目，加快形成我国工业互联网发展新优势。

#### 开源社区倡导开源文化，激发工业领域的开源氛围

T层和OT层的开源空间都很广阔，但是由于两者的应用场景和技术需求不同，开源社区的重心和方向也有所不同。在IT层，由于其应用范围广泛，开源也更加活跃。比如，开放原子开源基金会、Linux、Docker、Kubernetes等受众广的基金会，以及Apache基金会下的Apache Hadoop、Apache Spark项目等大型开源项目。而在OT层，出于优先保护商业利益，以及应用场景和技术需求相对专业等原因，导致整个领域的对开源的认识和开源氛围不足。

未来，工业互联网各方力量应积极利用开源社区的资源和平台，重点推动工业互联网领域OT层开源活动的普及和推广，为工业企业提供更好的开源解决方案和技术支持。其次，注重高校活动实践，开展校园行、组织开源软件开发比赛、提供技术讲座等活动，提高对开源文化的认知和参与度，进而推动整个领域的开源氛围。

## 4.4 开源在风洞等场景的应用

> 作者：李光杰，红山开源平台技术组负责人

计算流体力学（CFD，Computational Fluid Dynamics）发展对开源生态建设有重要影响。CFD兴起于20世纪60年代，是流体力学与计算机科学相互融合的新兴交叉学科，主要通过计算机和数值方法来求解流体力学的控制方程，对流体力学问题进行模拟和分析。90年代初期，随着计算机性能的优化提升，加速促进了CFD仿真软件在航天设计、化工处理、半导体等重要工业领域应用。当前，以Fluent（美国ANSYS企业主导研发）为代表的商用CFD仿真软件已得到广泛应用，在国际市场的占有率高达70%。为打破商用CFD仿真软件的垄断，由英国帝国理工大学Gosman团队编写，面向公众发行的开源流体学仿真软件OpenFoam应运而生，为用户提供了可扩展的数值模拟方法和求解器，进一步丰富了软件业态。

而目前，在CFD仿真软件的商业化和开源应用方面，我国头部研发力量薄弱，对外依附性较强。为提升本土工业应用软件的精确度、稳定性和计算效率，国产CFD软件选择拥抱开源，通过高效的在线协同机制，汇聚广大使用者和开发者群体，利用信息化创作环境和大规模在线协同开发工具实现技术协同攻关，共同打造国产自主CFD软件生态。 

### 4.4.1 风雷软件

风雷开源项目即风雷软件是中国空气动力研究与发展中心（CARDC）研发的面向流体工程的开源混合CFD平台。平台的建立遵循面向对象的设计理念，采用C++语言编程。风雷软件为了适应结构网格、非结构网格、混合网格、重叠网格等不同网格的计算，设计了具有良好通用性、可扩展性的体系结构和数据结构，实现了在同一个软件平台上，同时兼容结构求解器和非结构求解器。两种求解器可独立运行，也能耦合计算，即在流场中同时含有结构网格和非结构网格的情况下，在结构网格上调用结构求解器，在非结构网格上调用非结构求解器。风雷软件作为目前全球唯一同时兼容结构/非结构的开源平台，其计算范围覆盖低速、亚跨声速和高超声速。开发过程中，以现代软件工程方法为指导，结合CFD行业特点，设计了面向下一代的软件体系结构。目前，软件具备的主要功能点如下图所示。同时，风雷软件也提供常用前、后置软件接口，如Gridgen、Pointwise、ICEM-CFD、FieldView、Tecplot等。

![](https://img-blog.csdnimg.cn/b45ad0af7a88461a8e296bc3e600113e.png#pic_center)
 
风雷软件作为CFD领域国产开源生态建设的排头兵，积极参与技术交流与产学研合作。2021年10月，风雷软件在第九届“英特尔”杯全国并行应用挑战赛中，凭借《百亿级网格飞行器流动模式》作品夺得总决赛应用组冠军，团队通过采用MPI并行编程和OpenMP并行编程，首次突破了百亿级网格，以及英特尔30万核的规模限制，为快速飞行器设计奠定了基础。2022年6月，风雷软件承担江苏省科技厅重点研发计划《民用装备数值模拟求解框架研发与样本数据库构建关键技术研发》项目，为国产民用工业装备设计与研发流程优化贡献属于CFD领域的力量。南京航空航天大学韩省思课题组基于风雷软件发展了自适应RANS/LES湍流模拟方法，构造了适用于全尺度的大涡模式，为工程问题的湍流模拟应用提供了新思路。北京航空航天大学徐晶磊课题组发展了仅依赖湍动能输运方程的KDO (Kinetic Dependent Only)湍流模型相对于传统湍流模式更适用于高超声速高温非平衡流动，测试发现计算精度高于湍流传统模式。该模型可鲁棒计算一体化计算转捩/湍流、热化学反应流动，可进行大规模并行计算。中石化安全研究院基于风雷软件建立模拟污染物气体泄漏扩散的数值方法，对多种单组分、多组分混合气体扩散过程进行数值模拟研究。最终，形成一套研究污染物气体泄漏、扩散过程数值模拟和风险评估方法，对厂房、厂区等环境条件下气体泄漏、扩散过程的应急处置以及防护方案提供依据。中山大学国家超级计算广州中心张曦课题组基于风雷软件发展了MPI-CUDA异构并行框架，使得风雷GPU程序可以跨节点运行在多GPU上，为风雷程序在通用GPU上的大规模异构计算提供了贡献了一种解决方案。

![](RANS_LES自适应湍流模拟.gif)

<center>RANS/LES自适应湍流模拟</center>

![](https://img-blog.csdnimg.cn/1628b09393da4c0bba066dbe4f7cdf01.png#pic_center)

<center>GPU并行计算</center>

2016年4月，风雷软件面向全国免费发布，迄今为止，已有超过100家单位、1000人次申请下载使用；2020年7月，风雷软件面向“NNW项目”参研单位开源，行业内代码开源；2020年12月中旬，风雷软件正式面向全国用户开源发布。截止目前，风雷软件进行了5次版本更新，累计开源新功能37项，红山开源社区fork总数达633次，注册用户970余人，代码提交360次，收集国内用户意见反馈200余条，对其中符合风雷软件发展客观需要，且呼声较高的功能进行了技术突破与功能更新。在国内开源生态方面，2021年7月28日至30日，第2期国家数值风洞风雷开源软件暑期研讨班在线举办。会议采用线上直播方式，共685人（账号数）参会。2022年7月25日至29日，为期一周的国家数值风洞（NNW）风雷软件暑期研讨班（第3期）在四川绵阳成功举办。2022年7月，由中国空气动力研究与发展中心计算空气动力研究所组织的“国家数值风洞自主软件基础理论与工程应用精品系列课程进校园”活动盛大启幕，活动前两站为四川大学、厦门大学。风雷软件在两所高校开展了为期三天的培训课程，共计120名学员选修参与。2022年10月，风雷开源项目基于红山平台发布创客任务“悬赏”项目功能、性能开发问题解决方案，进一步推进CFD良性开源生态建设，激发人才自主创新意识。

风雷开源项目成立后，虽然构建了较为完整的社区生态，取得了一系列研究与应用成果，但仍面临切乎自身发展的问题与挑战，如：开发者、协作者知识产权保护措施不完备，部分用户自主创新意识淡薄，软件市场化可持续发展路线待探索等。因此，风雷开源项目将不断推进以下研究工作，包括：

1. 坚持开源可控，自主创新路线不动摇，加强人工智能、云计算等新型CFD应用领域布局；
2. 完善知识产权保护体系，尽可能减少被侵权的风险；
3. 加强开源创新模式，充分激发社区活力，提升协作者自主创新源动力；
4. 探索开源软件可持续发展路线，增加项目发展后劲。

### 4.4.2 IDRLNet

物理场的快速仿真与精确反演是飞行器设计和运行监测中面临的两个重要课题。在设计过程中，可以通过计算流体力学（CFD）实现物理场数值仿真。但是，CFD数值仿真往往需要消耗大量时间，在计算成本和准确性方面仍然面临许多挑战。在飞行器运行过程中，性能监测涉及物理场反演，为满足实时性需求，数据驱动方法被引入其中。然而受限于传感器数量和精度，单纯数据驱动的方式并不能满足物理场的重建需求。面对这些困难，内嵌物理知识神经网络 (Physics-Informed Neural Network，PINN)作为一种新兴深度学习技术，逐渐被应用到CFD领域中。PINN保持了神经网络对数据高效利用特性的同时，在神经网络中内嵌物理知识，从而实现数据与物理知识混合驱动。为解决飞行器设计优化过程中物理场快速仿真问题和运行监测阶段物理场精确反演问题，国防科技创新研究院智能设计与鲁棒学习团队推出了基于PINN的微分方程智能求解框架IDRLnet。
IDRLnet是一款以飞行器设计优化任务为应用背景、基于PyTorch开发的开源框架。IDRLnet主要包括几何生成、数据处理、神经网络构建和偏微分方程求解四大模块。该框架提供了二维与三维的基本几何对象，并支持几何对象之间的集合运算。PINN方法的基本思路是对采样配点上的数据和方程残差进行拟合，因此，面向该领域学术研究需求，几何生成模块提供了内部采样方法及其对应符号距离场（SDF）、边界采样方法及其对应法向量。数据源包括采样得到的数据节点和外部数据节点，可用于代理模型构建与逆问题求解。该框架内置了多种神经网络架构与常见微分方程，便于多种方法比较研究。处理复杂物理场时可能涉及较多对象，物理方程与采样点数据之间的耦合较为复杂。为了应对潜在的复杂关联问题，该框架在架构设计上解耦了数据源、物理方程、神经网络之间的依赖，各个计算对象如微分方程和神经网络相关的计算节点可以进行单独定义。最后，基于给定数据源，自动获取需要的依赖结点；构建计算图，利用拓扑排序构造计算流水线；整合多个流水线，得到最终损失函数，进而利用反向传播结合梯度优化方法完成训练。考虑到PINN本身仍没有发展成熟，更多高效算法亟待开发。因此，该框架提供了回调机制支持用户自定义算法，使得PINN新方法也容易集成到框架中。

IDRLnet包含了大量典型测试案例。首先，面向飞行器设计参数优化问题，IDRLnet在不依赖外部数值仿真提供训练数据的条件下，能够实现物理场对设计变量的实时响应，大幅压缩“设计参数-数值仿真”迭代循环的周期。其次，对于含有异常传感数据的物理场重建问题，IDRLnet提供多种鲁棒优化方法可以对物理场参数进行反演识别。为进一步提升效率与精度，IDRLnet提供了自适应采样方法，动态改变各区域采样权重。同时，该框架还支持简单偏微分方程的变分形式求解。IDRLnet于2021年7月在红山开源平台发布0.1.0版本，并获得2022年度开源项目贡献奖。作为国内首款基于内嵌物理知识神经网络的自主开源框架，IDRLnet助力内嵌物理知识神经网络领域的学术研究和应用落地。IDRLnet已应用于卫星仓板热分析与飞行器流场感知等问题中，相关成果已获得成果转化。PINN创始人Raissi教授在相关课程上推荐了IDRLnet求解库，该框架在国内外已具有一定影响力。

目前PINN求解效率还有待提高，其网络架构也存在一定局限性。IDRLnet计划提升CPU/GPU并行化的高性能计算能力，使其适应并行算法；支持更多新型神经网络架构与物理机器学习模型；融合传统数值求解器；引入自适应的超参数选择方法，提高模型收敛性；结合设计优化，支持多种优化器。同时，进一步整合更多科学工程领域的算例，为工程应用奠定基础。随着内嵌物理知识神经网络相关研究不断深入，团队也在开源后对IDRLnet的功能和性能进行了不断完善和改进，预计于2023年中发布IDRLnet0.2.0版本。

### 4.4.3 OpenMatrix

MATLAB是美国MathWorks公司出品的商业矩阵计算软件，软件具有编程语言简洁易懂、计算功能强大、丰富的领域工具箱等优势，已成为快速实现算法验证和生成原型软件的有效编程工具，广泛用于科学计算、可视化以及交互式程序设计等设计建模和数值分析领域。自2020年起，我国多家单位被列入美国政府的进出口管制名单，禁止使用MATLAB服务。为实现大型矩阵计算软件自主可控，解决大量基于MATLAB编程语言的软件原型遗产代码问题，同时缓解国产软件性能不足问题，迫切需要研发一款面向数值计算的高性能矩阵计算软件。

国防科大龚春叶团队研发的OpenMatrix矩阵计算软件将对标商用MATLAB软件，旨在开发构建一款开源的适用于数值计算和科学工程计算的高级语言交互式环境，为计算流体力学、电磁学、气候气象等数值计算领域的设计建模与专业分析提供数值计算服务。软件的定位一方面是解决禁运问题，满足遗产MATLAB代码快速适配需求，另一方面是利用高性能计算机实现并行优化，充分发挥计算性能。此外，OpenMatrix矩阵计算软件着重解决MATLAB并行计算能力弱、性能效率低等问题，针对重要领域开发并行求解工具箱，在不修改源程序的前提下实现性能跃升，利用并行算力优势弥补软件水平差距，弥补中美软件水平差距。

当前OpenMatrix矩阵计算软件版本已具备提供高级语言解释器，实现了语言的前端解释功能，支持将MATLAB语言转换为中间代码，支持高级编程语言和交互式计算；支持面向高级语言的数据和通用函数兼容技术，提供统一编程接口，能够用简易编码方式支持各类问题的高效试算，减轻使用者的编程负担和应用性能优化难度；已实现不包括第三方工具箱函数的大部分通用函数覆盖，包括：初等数学函数库、基本矩阵函数库、二维三维图形函数库、逻辑字符运算函数库、调试与控制流程函数库、时间与日期函数库和特殊数学函数库等，支持面向多种程序设计语言的统一外部编程接口，支持不依赖第三方库的MATLAB程序移植，支持遗产MATLAB代码的快速适配。

OpenMatrix矩阵计算软件项目的下阶段规划是进一步开发和完善并行求解工具箱，突破关键领域算子并行优化，支持用户利用高性能计算机实现并行计算，使现有代码充分发挥底层高性能计算系统的算力资源，同时拟开发支持求解偏微分方程组的各种数值方法，包括有限差分、有限体积和有限元方法，提供面向CFD计算的网格生成和自适应细化工具箱；最后充分开放共享，提供海纳百川的软件框架，着重解决标准化接口问题，使潜在的用户群体都能参与软件开发，丰富软件的工具箱和功能模块。OpenMatrix矩阵计算软件将迭代发展形成生态，支撑航空航天飞行器装备设计、环境仿真、密码分析、生物安全等传统数值计算领域应用，持续提供高效的数值计算服务。目前OpenMatrix矩阵计算软件已发布基于天河超算在线版，拟在三年内进一步拓展应用到1000家科研单位，拓展用户10000名。
